"""Plot the input matrix."""

from absl import app
from absl import flags
import matplotlib.pyplot as plt
import matplotlib.colors as colors
import numpy as np

flags.DEFINE_string('input_file', 'input.npy', 'File with input matrix')
flags.DEFINE_string('output_file', None, 'File with spectrum plot')
flags.DEFINE_float('gamma', 0.5, 'Contrast')
FLAGS = flags.FLAGS

def main(argv) -> None:
  mat = np.load(FLAGS.input_file).T
  plt.imshow(mat, norm=colors.PowerNorm(gamma=FLAGS.gamma), cmap='PuBu_r')
  plt.axis('off')
  if FLAGS.output_file is not None:
    plt.savefig(FLAGS.output_file, bbox_inches='tight')
  else:
    plt.show()


if __name__ == '__main__':
  app.run(main)
